package com.b2lmobitech.spottest;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.Toast;

import com.b2lmobitech.spottest.network.MyRequestQueue;
import com.b2lmobitech.spottest.network.URL;
import com.b2lmobitech.spottest.utils.MySnackbar;
import com.google.firebase.iid.FirebaseInstanceId;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class ForgotPassword extends AppCompatActivity {

    EditText userEmail;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_forgotpassword);

        userEmail=findViewById(R.id.userEmail);
        findViewById(R.id.sendPassword).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(isValid()){
                    sendPassword();
                }
            }
        });
    }

    private boolean isValid(){
        MySnackbar snackbar=MySnackbar.getInstance(this);

        if(userEmail.getText().toString().isEmpty()){
            snackbar.show("Enter Email");
            return false;
        }else if (!android.util.Patterns.EMAIL_ADDRESS.matcher(userEmail.getText().toString()).matches()) {
            snackbar.show("Enter Valid Email");
            return false;
        }

        closeKeyboard();
        return true;
    }

    private void closeKeyboard() {
        InputMethodManager inputManager = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        if(inputManager.isActive()) {
            inputManager.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);
        }
    }

    private void sendPassword() {

        Map<String, String> params = new HashMap<>();
        params.put("email", userEmail.getEditableText().toString());

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.addToQueue(URL.FORGOT, params, new MyRequestQueue.MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    sendPassword(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void sendPassword(JSONObject jsonObject) throws JSONException {
        if(jsonObject.getInt("s")==1){
            Toast.makeText(getApplicationContext(),jsonObject.getString("m"),Toast.LENGTH_SHORT).show();
        }else{
            MySnackbar snackbar=MySnackbar.getInstance(this);
            snackbar.show(jsonObject.getString("m"));
        }
    }


}
