package com.b2lmobitech.spottest.adapter;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.spottest.R;
import com.b2lmobitech.spottest.utils.DateUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;

public class HistoryAdapter extends RecyclerView.Adapter<HistoryAdapter.viewHolder> {

    private JSONArray jsonArray;
    private ItemSelectedListener itemSelectedListener;
    private Context context;


    public HistoryAdapter(JSONArray jsonArray, ItemSelectedListener itemSelectedListener) {
        this.jsonArray = jsonArray;
        this.itemSelectedListener = itemSelectedListener;
    }

    @NonNull
    @Override
    public viewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.list_tests_constrain,parent,false);
        context=parent.getContext();
        return new viewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull viewHolder holder, int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());
            holder.label.setText(jsonObject.getString("question_paper_name"));
            holder.infoText1.setText(String.format("Sections : %s", jsonObject.getString("counts")));

            if(!jsonObject.getString("category").equals("null")){
                holder.categoty.setVisibility(View.VISIBLE);
                holder.bullot2.setVisibility(View.VISIBLE);
                holder.categoty.setText(jsonObject.getString("category"));
            }else{
                holder.categoty.setVisibility(View.GONE);
                holder.bullot2.setVisibility(View.GONE);
            }

            switch (jsonObject.getString("completed").toLowerCase()) {
                case "null":
                case "no":
                    holder.timerIcon.setVisibility(View.GONE);
                    holder.timerText.setVisibility(View.GONE);
                    if(jsonObject.getString("showResult").equalsIgnoreCase("yes")){
                            holder.nextIcon.setVisibility(View.VISIBLE);
                            holder.startText.setVisibility(View.VISIBLE);
                            holder.startText.setText("Try Now");
                            holder.durationText.setText(DateUtils.getNormalHour(jsonObject.getString("paper_duration")));
                            holder.bullot.setVisibility(View.VISIBLE);
                            holder.durationText.setVisibility(View.VISIBLE);
                    }else{
                            holder.nextIcon.setVisibility(View.GONE);
                            holder.startText.setVisibility(View.GONE);
                            holder.durationText.setVisibility(View.GONE);
                            holder.bullot.setVisibility(View.GONE);
                    }
                    holder.scheduledTime.setText(DateUtils.getNormalDatetime(jsonObject.getString("examschedule_DT")));
                    break;
                case "yes":
                    holder.startText.setText("Result");
                    holder.timerIcon.setVisibility(View.GONE);
                    holder.timerText.setVisibility(View.GONE);
                    holder.durationText.setVisibility(View.GONE);
                    holder.scheduledTime.setText(DateUtils.getNormalDatetime(jsonObject.getString("completed_datetime")));
                    if(jsonObject.getString("showResult").equalsIgnoreCase("yes")){
                        holder.nextIcon.setVisibility(View.VISIBLE);
                        holder.startText.setVisibility(View.VISIBLE);
                    }else{
                        holder.nextIcon.setVisibility(View.GONE);
                        holder.startText.setVisibility(View.GONE);
                    }
                    break;
            }
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    class viewHolder extends RecyclerView.ViewHolder{

        TextView label,infoText1,infoText2,startText,scheduledTime,durationText,timerText,categoty,bullot,bullot2;


        ImageView timerIcon,nextIcon;


        public viewHolder(View itemView) {
            super(itemView);
            label=itemView.findViewById(R.id.label);
            infoText1=itemView.findViewById(R.id.infoText1);
            infoText2=itemView.findViewById(R.id.infoText2);
            startText=itemView.findViewById(R.id.startText);
            categoty=itemView.findViewById(R.id.categoty);
            nextIcon=itemView.findViewById(R.id.nextIcon);

            timerText=itemView.findViewById(R.id.timerText);

            timerIcon=itemView.findViewById(R.id.timerIcon);
            itemView.findViewById(R.id.active).setVisibility(View.GONE);
            scheduledTime=itemView.findViewById(R.id.scheduledTime);
            durationText=itemView.findViewById(R.id.durationText);
            bullot=itemView.findViewById(R.id.bullot);
            bullot2=itemView.findViewById(R.id.bullot2);
            itemView.findViewById(R.id.bullot).setVisibility(View.GONE);
            itemView.findViewById(R.id.infoIcon).setVisibility(View.GONE);

            nextIcon.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    itemSelectedListener.selected(getAdapterPosition());
                }
            });
            startText.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    itemSelectedListener.selected(getAdapterPosition());
                }
            });

            Typeface typeface = Typeface.createFromAsset(context.getAssets(), "fonts/calibrib.ttf");
            label.setTypeface(typeface);
        }
    }


}
