package com.b2lmobitech.spottest.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.spottest.R;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MembersAdapter extends RecyclerView.Adapter<MembersAdapter.viewHolder> {

    private JSONArray jsonArray;

    public MembersAdapter(JSONArray jsonArray) {
        this.jsonArray = jsonArray;
    }



    @NonNull
    @Override
    public viewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.list_members,parent,false);
        return new viewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull viewHolder holder, int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());
            if(!jsonObject.getString("name").substring(0,1).isEmpty()) {
                holder.text1.setText(jsonObject.getString("name").substring(0, 1));
            }
            holder.infoText.setText(String.format("Joined On: %s", jsonObject.getString("registered_datetime")));
            holder.label.setText(jsonObject.getString("name"));
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    class viewHolder extends RecyclerView.ViewHolder{

        TextView label,text1,infoText;

        public viewHolder(View itemView) {
            super(itemView);
            label=itemView.findViewById(R.id.label);
            text1=itemView.findViewById(R.id.text1);
            infoText=itemView.findViewById(R.id.infoText);
        }
    }

}
