package com.b2lmobitech.spottest.adapter;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.spottest.R;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PreviewSectionAdapter extends RecyclerView.Adapter<PreviewSectionAdapter.viewHolder> {

    private JSONArray jsonArray;

    public PreviewSectionAdapter(JSONArray jsonArray) {
        this.jsonArray = jsonArray;
    }

    @NonNull
    @Override
    public viewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.list_section,parent,false);
        return new viewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull viewHolder holder, int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());

            holder.label.setText(jsonObject.getString("section_name"));
            holder.startText.setText("Answer");
            holder.infoText.setText(String.format("Questions : %s", jsonObject.getString("counts")));

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    class viewHolder extends RecyclerView.ViewHolder{

        TextView label,infoText,startText;
        LinearLayout nextLayout;
        ImageView startImage;

        viewHolder(View itemView) {
            super(itemView);
            label = itemView.findViewById(R.id.label);
            infoText = itemView.findViewById(R.id.infoText);
            startText = itemView.findViewById(R.id.startText);
            startImage = itemView.findViewById(R.id.startImage);
            nextLayout = itemView.findViewById(R.id.nextLayout);



            nextLayout.setVisibility(View.GONE);
        }

    }

}
