package com.b2lmobitech.spottest.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.spottest.R;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResultSectionAdapter extends RecyclerView.Adapter<ResultSectionAdapter.viewHolder> {

    private Context context;
    private JSONArray jsonArray;
    private ItemSelectedListener itemSelectedListener;
    private boolean showNext=true;

    public ResultSectionAdapter(Context context, JSONArray jsonArray, boolean showNext) {
        this.context = context;
        this.jsonArray = jsonArray;
        itemSelectedListener= (ItemSelectedListener) context;
        this.showNext=showNext;
    }

    public ResultSectionAdapter( JSONArray jsonArray, boolean showNext) {
        this.jsonArray = jsonArray;
        this.showNext=showNext;
    }

    public ResultSectionAdapter(JSONArray jsonArray, ItemSelectedListener itemSelectedListener) {
        this.jsonArray = jsonArray;
        this.itemSelectedListener= itemSelectedListener;
    }

    @NonNull
    @Override
    public viewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.list_section,parent,false);
        return new viewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull viewHolder holder, int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());
            holder.label.setText(jsonObject.getString("section_name"));

            if(showNext){
                holder.nextLayout.setVisibility(View.VISIBLE);
                holder.startImage.setImageResource(R.drawable.ic_arrow_right);
                holder.startText.setText("Answers");
            }else{
                holder.nextLayout.setVisibility(View.GONE);
            }

            holder.infoText.setText(String.format("Correct Answers : %s/%s", jsonObject.getString("correct"),jsonObject.getString("counts")));

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    class viewHolder extends RecyclerView.ViewHolder{

        TextView label,infoText,startText;
        LinearLayout nextLayout;
        ImageView startImage;

        viewHolder(View itemView) {
            super(itemView);
            label=itemView.findViewById(R.id.label);
            infoText=itemView.findViewById(R.id.infoText);
            startText=itemView.findViewById(R.id.startText);
            startImage=itemView.findViewById(R.id.startImage);
            nextLayout=itemView.findViewById(R.id.nextLayout);


            nextLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    nextLayout.setClickable(false);
                    itemSelectedListener.selected(getAdapterPosition());
                    nextLayout.setClickable(true);
                }
            });
        }

    }

    public void setItemSelectedListener(ItemSelectedListener itemSelectedListener) {
        this.itemSelectedListener = itemSelectedListener;
    }

}
