package com.b2lmobitech.spottest.adapter;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.spottest.R;
import com.b2lmobitech.spottest.encaps.Section;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class SectionAdapterlocal extends RecyclerView.Adapter<SectionAdapterlocal.viewHolder> {

    //private JSONArray jsonArray;
    private ArrayList<Section> sectionslocalArray;
    private ItemSelectedListener itemSelectedListener;
    private boolean showNext;
private Context adaptercontext;

   // public SectionAdapter(Context mycontext, JSONArray jsonArray, ItemSelectedListener itemSelectedListener, boolean showNext) {
    public SectionAdapterlocal(Context mycontext, ArrayList<Section> sectionslocalArray, ItemSelectedListener itemSelectedListener, boolean showNext) {
        this.sectionslocalArray = sectionslocalArray;
        this.itemSelectedListener= itemSelectedListener;
        this.showNext=showNext;
         this.adaptercontext= mycontext;
    }

    @NonNull
    @Override
    public viewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.list_section,parent,false);
        return new viewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull viewHolder holder, int position) {
//        try {
            //JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());

            holder.label.setText(sectionslocalArray.get(position).getsectionname());


            if (showNext) {
                holder.nextLayout.setVisibility(View.VISIBLE);
//                Toast.makeText(adaptercontext,"a_answered="+sectionslocalArray.get(position).getanswered(),Toast.LENGTH_LONG).show();
//                Toast.makeText(adaptercontext,"a_counts="+sectionslocalArray.get(position).getcounts(),Toast.LENGTH_LONG).show();
                if(sectionslocalArray.get(position).getanswered()==0 || sectionslocalArray.get(position).getanswered()!=sectionslocalArray.get(position).getcounts()){
                    holder.startImage.setImageResource(R.drawable.ic_arrow_right);
                    holder.startText.setText("Answer");
                    if(sectionslocalArray.get(position).getanswered()==0){
                        holder.infoText.setText(String.format("Questions : %s", sectionslocalArray.get(position).getcounts()));
                    }else{
                        holder.infoText.setText(String.format("Answered: %s/%s",sectionslocalArray.get(position).getanswered(),sectionslocalArray.get(position).getcounts()));
                    }
                }else{
                    holder.infoText.setText(String.format("Answered: %s/%s",sectionslocalArray.get(position).getanswered(),sectionslocalArray.get(position).getcounts()));
                    holder.startText.setVisibility(View.GONE);
                    holder.startImage.setVisibility(View.GONE);
                }
            }else{
                holder.startText.setText("View");
                holder.startImage.setImageResource(R.drawable.ic_arrow_right);
                holder.infoText.setText(String.format("Answered : %s/%s",sectionslocalArray.get(position).getanswered(),sectionslocalArray.get(position).getcounts()));
            }
//        } catch (JSONException e) {
//           // e.printStackTrace();
////            Toast.makeText(adaptercontext,"error2= "+e.toString(),Toast.LENGTH_SHORT).show();
//        }
    }

    @Override
    public int getItemCount() {
        return sectionslocalArray.size();
    }

    class viewHolder extends RecyclerView.ViewHolder{

        TextView label,infoText,startText;
        LinearLayout nextLayout;
        ImageView startImage;

        viewHolder(View itemView) {
            super(itemView);
            label=itemView.findViewById(R.id.label);
            infoText=itemView.findViewById(R.id.infoText);
            startText=itemView.findViewById(R.id.startText);
            startImage=itemView.findViewById(R.id.startImage);
            nextLayout=itemView.findViewById(R.id.nextLayout);



            nextLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
//                    if(isNetworkAvailable()) {
                            if (itemSelectedListener != null) {
                                itemSelectedListener.selected(getAdapterPosition());
                            }
//                    }else
//                    {
//                        Toast.makeText(adaptercontext,"please check internet connection ",Toast.LENGTH_SHORT).show();
//                    }
                }
            });
        }

    }
    private boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager
                = (ConnectivityManager) adaptercontext.getSystemService(adaptercontext.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }
}
