package com.b2lmobitech.spottest.utils;

import android.support.annotation.NonNull;
import android.util.Log;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

/**
 * Created by home on 4/23/2018.
 */

public class DateUtils {

    public static String getCurrentDateTime() {
        Calendar c1 = Calendar.getInstance();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss",Locale.getDefault());
        return df1.format(c1.getTime());
    }

    private static String getByFormat(String format, Date date){
        return  new SimpleDateFormat(format).format(date);
    }

    public static String getCurrentDate() {
        return getByFormat("yyyy-MM-dd",Calendar.getInstance().getTime());
    }

    public static  String getNormalDatetime(String datetime) throws ParseException {
        Date date=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss",Locale.getDefault()).parse(datetime);
        return getByFormat("dd-MM-yyyy hh:mm a",date);
    }

    public static  String getNormalDate(String datetime) throws ParseException {
        Date date=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss",Locale.getDefault()).parse(datetime);
        return getByFormat("dd-MM-yyyy",date);
    }

    public static  String getNormalHour(String time) throws ParseException {

        Date date=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss",Locale.getDefault()).parse("0000-00-00 "+time);

        String days=getByFormat("dd",date);
        String hour=getByFormat("HH",date);
        String minitues=getByFormat("mm",date);

        if(hour.equalsIgnoreCase("00") && minitues.equalsIgnoreCase("00")){
            return getByFormat("ss",date)+" sec";
        }else if(hour.equalsIgnoreCase("00")){
            return getByFormat("mm",date)+"min";
        }else{
            return getByFormat("HH",date)+"h "+getByFormat("mm",date)+"min";
        }
    }


    public static String getNormalHour(int seconds) {
        int day = (int) TimeUnit.SECONDS.toDays(seconds);
        long hours = TimeUnit.SECONDS.toHours(seconds) -
                TimeUnit.DAYS.toHours(day);
        long minute = TimeUnit.SECONDS.toMinutes(seconds) -
                TimeUnit.HOURS.toMinutes(TimeUnit.SECONDS.toHours(seconds));
        long second = TimeUnit.SECONDS.toSeconds(seconds) -
                TimeUnit.MINUTES.toSeconds(TimeUnit.SECONDS.toMinutes(seconds));
        Log.d("days","Day " + day + " Hour " + hours + " Minute " + minute + " Seconds " + second);
        if(day==0 && hours==0 && minute==0){
            return second+"sec";
        }else if(day==0 && hours==0){
            return minute +"min";
        }else if(day==0){
            return hours+"h "+minute+"min";
        }else{
            return day+"d "+ hours+"h "+minute+"min";
        }

    }



    public static Date fromDateTime(String string) throws ParseException {
       return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss",Locale.getDefault()).parse(string);
    }

    public static Date fromDate(String string) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd",Locale.getDefault()).parse(string);
    }



    public static Date currentDate() {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(new SimpleDateFormat("yyyy-MM-dd").format(new Date().getTime()));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return new Date();
    }

    public static int daysbetween(Date firstdate) {

        long diif = firstdate.getTime() - currentDate().getTime();
        return (int) (diif / (1000 * 60 * 60 * 24));
    }

    public static String monthNameFromDate(String date) throws ParseException {
        Date firstdate=new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH).parse(date);
        return new SimpleDateFormat("MMM",Locale.ENGLISH).format(firstdate);
    }

    public static String monthNameFromDateTime(String datetime) throws ParseException {
        Date firstdate=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(datetime);
        return new SimpleDateFormat("MMM",Locale.ENGLISH).format(firstdate);
    }

    public static String monthYearFromDate(String datetime) throws ParseException {
        Date firstdate=new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH).parse(datetime);
        return new SimpleDateFormat("MMM yyyy",Locale.ENGLISH).format(firstdate);
    }

    public static String dateNumberFromDate(String date){
            return date.substring(8,10);
    }

    public static int compareToday(String date) throws ParseException {
        Date firstdate=new SimpleDateFormat("yyyy-MM-dd").parse(date);
        long diif = firstdate.getTime() - currentDate().getTime();
        return (int) (diif / (1000 * 60 * 60 * 24)) ;
    }



    public static int compareTodayWithTime(String date) throws ParseException {
        Date firstdate=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date);
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        return compareToday(df1.format(firstdate));
    }


    public static int daysbetween(Date firstdate, Date seconddate) {

        long diif = firstdate.getTime() - seconddate.getTime();
        return (int) (diif / (1000 * 60 * 60 * 24));
    }



    public static String getDueDateString(String date) throws ParseException {
        int x=compareToday(date);
        if(x==0){
            return "Due Today";
        }else if(x==1){
            return "Due Tomorrow";
        }else if(x<0){
            x=x*-1;
            if(x==1){
                return "Due Yesterday";
            }else{
                return x+" Days late";
            }
        }
        else{
            return "Due in "+x+" Days";
        }
    }

    public static String getLateDateString(String date) throws ParseException{
        int x=compareToday(date)*-1;
        if(x==0){
            return "Due Today";
        }else if(x==1) {
            return "1 Day late";
        }else{
            return x+" Days late";
        }
    }

    @NonNull
    public static String getUpcomingDateString(String date) throws ParseException{
        int x=compareToday(date);
        if(x==1) {
            return "Starting Tommorrow";
        }else if(x<0){
            x=x*1;
            if(x==1){
                return "Due Yesterday";
            }else{
                return x+" Days late";
            }
        }else{
            return "Starting in "+ x +" Days";
        }
    }

    public static String getCompletedDateString(String date) throws ParseException{
        int x=compareTodayWithTime(date)*-1;
        if(x==0) {
            return "Completed Today";
        }else if(x==1){
            return "Completed Yesterday";
        }else{
            return "Completed "+ x +" Days ago";
        }
    }



}
