package com.b2lmobitech.spottest;

import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.spottest.adapter.ItemSelectedListener;
import com.b2lmobitech.spottest.adapter.ResultSectionAdapter;
import com.b2lmobitech.spottest.encaps.Question;
import com.b2lmobitech.spottest.network.MyRequestQueue;
import com.b2lmobitech.spottest.network.URL;
import com.b2lmobitech.spottest.sql.DataBase;
import com.b2lmobitech.spottest.sql.tables.AnswerTable;
import com.b2lmobitech.spottest.sql.tables.QuestionTable;
import com.b2lmobitech.spottest.utils.Preference;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MockResultActivity2 extends AppCompatActivity {

    String section,assignId;
    LinearLayout mainLayout;
    DataBase dataBase;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_result2);
        section=getIntent().getStringExtra("section");
        assignId=getIntent().getStringExtra("assignId");

        mainLayout=findViewById(R.id.mainLayout);
        dataBase=new DataBase(this);

        getSupportActionBar().setTitle(getIntent().getStringExtra("name"));
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        try {
            getAnswers();
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void getAnswers() throws JSONException {
        JSONArray jsonArray=dataBase.getQuestionAnswers(section,assignId);
        Log.d("result",jsonArray.toString());

        for(int i=0; i<jsonArray.length(); i++){
            addView(jsonArray.getJSONObject(i),i+1);
            //addDivider();
        }

    }

    private void setAnswers(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray=jsonObject.getJSONArray("sections");
        for(int i=0; i<jsonArray.length(); i++){
            addView(jsonArray.getJSONObject(i),i+1);
        }
    }

    private void addView(final JSONObject jsonObject, int i) throws JSONException {

        View view=getLayoutInflater().inflate(R.layout.model_answer,mainLayout,false);
        TextView title=view.findViewById(R.id.question);
        title.setText(i+"."+jsonObject.getString("question"));
        TextView answer=view.findViewById(R.id.answer);
        TextView corectAnswer=view.findViewById(R.id.corectAnswer);
        LinearLayout corectAnswerLayout=view.findViewById(R.id.corectAnswerLayout);

        String correctAnswerId=dataBase.getCorrectAnswerId(assignId,jsonObject.getString(QuestionTable.QUESTIONID));
        //Toast.makeText(MockResultActivity2.this,"optionvalue="+jsonObject.getString("option"),Toast.LENGTH_LONG).show();
        if(jsonObject.getString("option").equals("")){
            answer.setText("Dont Know");
            answer.setTextColor(Color.RED);
            corectAnswer.setText(dataBase.getOptionName(correctAnswerId));
        }
        else if(jsonObject.getString("option").equals("null")){
            answer.setText("Not Answered");
            answer.setTextColor(Color.RED);
            corectAnswer.setText(dataBase.getOptionName(correctAnswerId));
        }else{
            answer.setText(jsonObject.getString("option"));
            if(correctAnswerId.equals(jsonObject.getString(AnswerTable.OPTIONID))){
                answer.setTextColor(getResources().getColor(R.color.correctAnswerColor));
                corectAnswerLayout.setVisibility(View.GONE);
            }else{
                answer.setTextColor(Color.RED);
                corectAnswer.setText(dataBase.getOptionName(correctAnswerId));
            }
        }

        mainLayout.addView(view);
    }

    private void addDivider(){
        View view=new View(this);
        view.setBackgroundColor(Color.DKGRAY);
        view.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,1));
        mainLayout.addView(view);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if(item.getItemId()==android.R.id.home){
            onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

}
