package com.b2lmobitech.spottest.adapter;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;


import com.b2lmobitech.spottest.R;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GroupsAdapter extends RecyclerView.Adapter<GroupsAdapter.viewHolder> {

    private Context context;
    private JSONArray jsonArray;
    private ItemSelectedListener itemSelectedListener;

    public GroupsAdapter(JSONArray jsonArray, ItemSelectedListener itemSelectedListener) {
        this.jsonArray = jsonArray;
        this.itemSelectedListener = itemSelectedListener;
    }

    @NonNull
    @Override
    public viewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.list_groups,parent,false);
        context=parent.getContext();
        return new viewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull viewHolder holder, int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());

            if(!jsonObject.getString("group_name").substring(0,1).isEmpty()) {
                holder.text1.setText(jsonObject.getString("group_name").substring(0, 1).toUpperCase());
            }
            if(jsonObject.getString("members").equals("null")){
//                holder.userCountIcon.setVisibility(View.GONE);
                holder.infoText.setVisibility(View.GONE);
            }else{
                holder.infoText.setText(jsonObject.getString("members"));
//                holder.userCountIcon.setVisibility(View.VISIBLE);
                holder.infoText.setVisibility(View.INVISIBLE);
            }
            if(jsonObject.getString("upcoming").equals("0")){
//                holder.upcomingCountIcon.setVisibility(View.GONE);
                holder.upcomingCount.setVisibility(View.GONE);
            }else{
                holder.upcomingCount.setText(jsonObject.getString("upcoming"));
//                holder.upcomingCountIcon.setVisibility(View.VISIBLE);
                holder.upcomingCount.setVisibility(View.VISIBLE);
            }


            holder.label.setText(jsonObject.getString("group_name"));
            if(jsonObject.getString("ongoing").equals("true"))
            {
                holder.nextArrow.setVisibility(View.VISIBLE);
            }
            else
            {
                holder.nextArrow.setVisibility(View.GONE);
            }
            if(jsonObject.getString("missed").equals("0"))
            {
                holder.missedCount.setVisibility(View.GONE);
            }
            else
            {
                holder.missedCount.setVisibility(View.VISIBLE);
                holder.missedCount.setText(jsonObject.getString("missed"));
            }
//            holder.upcomingCount.setText(jsonObject.getString("upcoming"));
//            holder.completedCount.setText(jsonObject.getString("completed"));

        } catch (JSONException e) {
            e.printStackTrace();
            //Toast.makeText(context,e.toString(),Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    class viewHolder extends RecyclerView.ViewHolder{

        TextView label,text1,infoText,upcomingCount,missedCount;//completedCount
        TextView nextArrow;//upcomingCountIcon
        View active;


       public viewHolder(View itemView) {
            super(itemView);
            label=itemView.findViewById(R.id.label);
            text1=itemView.findViewById(R.id.text1);
            infoText=itemView.findViewById(R.id.infoText);
            upcomingCount=itemView.findViewById(R.id.upcomingCount);
//            completedCount=itemView.findViewById(R.id.completedCount);
            missedCount=itemView.findViewById(R.id.missedCount);
//           upcomingCountIcon=itemView.findViewById(R.id.upcomingCountIcon);
           nextArrow = itemView.findViewById(R.id.nextArrow);
//            Typeface typeface = Typeface.createFromAsset(context.getAssets(), "fonts/calibrib.ttf");
//            label.setTypeface(typeface);
            //--swathi--
//           label.setTextColor(Color.parseColor("#29AB87"));
          // text1.setTextColor(Color.parseColor("#29AB87"));
            //--swathi--
           itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    itemSelectedListener.selected(getAdapterPosition());
                }
            });
        }
    }

}
