package com.b2lmobitech.spottest.utils;

import android.app.Activity;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.view.View;

import com.b2lmobitech.spottest.R;


/**
 * Created by home on 3/24/2018.
 */

public class MySnackbar {
    private static Snackbar snackbar;

    private MySnackbar(Activity activity){
        CoordinatorLayout coordinatorLayout = activity.findViewById(R.id.coordinatorLayout);
        snackbar = Snackbar.make(coordinatorLayout, "", Snackbar.LENGTH_SHORT);
    }

    public static synchronized MySnackbar getInstance(Activity activity){
        return new MySnackbar(activity);
    }


    public void show(String message,String actionText){
        snackbar.setText(message);
        snackbar.setAction(actionText, new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                snackbar.dismiss();
            }
        });
        snackbar.show();
    }

    public void show(String message){
        show(message,"Close");
    }

    public void dismiss(){
        if(snackbar.isShown()){
            snackbar.dismiss();
        }
    }

}
