package com.b2lmobitech.spottest.utils;

import android.Manifest;
import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;

import com.b2lmobitech.spottest.BuildConfig;

public class PermissionSingleton {

    private static PackageManager packageManager;
    private static AppOpsManager appOpsManager;
    private static final PermissionSingleton ourInstance = new PermissionSingleton();
    private static Context context;

    public static PermissionSingleton getInstance(Context context) {
        PermissionSingleton.context =context;
        if(packageManager==null){
            packageManager=context.getPackageManager();
            appOpsManager= (AppOpsManager) context.getSystemService(Context.APP_OPS_SERVICE);
        }
        return ourInstance;
    }

    private PermissionSingleton() {}

    public  boolean isUsageAccessAccessGranted() {
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(BuildConfig.APPLICATION_ID, 0);
            int mode = 0;
            mode = appOpsManager.checkOpNoThrow(AppOpsManager.OPSTR_GET_USAGE_STATS,
                    applicationInfo.uid, applicationInfo.packageName);
            return (mode == AppOpsManager.MODE_ALLOWED);

        } catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

}
