package com.b2lmobitech.spottest.utils;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaScannerConnection;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Environment;
import android.support.v7.app.AlertDialog;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.widget.TextView;


import com.b2lmobitech.spottest.R;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/**
 * Created by home on 2/12/2018.
 */

public class Utility {

    public static String imgToString(Bitmap bitmap){
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, stream);
        byte[] byteArray = stream.toByteArray();
        return Base64.encodeToString(byteArray, Base64.DEFAULT);
    }

    public static Bitmap bitmap(String str){
        byte[] decodedBytes = Base64.decode(str, 0);
        return BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
    }

    public static File getCapturedImageFile() {
        File mediaFile = null;
        File mediaStorageDir = new File(Environment.getExternalStorageDirectory()+"/Rover");
//        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss",
//                Locale.getDefault()).format(new Date());
//        File mediaStorageDir = new File(Environment.getExternalStorageDirectory()+"/SpotTest");
//        File mediaStorageDir = new File(Environment
//                .getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES),
//                "SpotTest");
        if (!mediaStorageDir.exists()) {
            if (!mediaStorageDir.mkdirs()) {
                return null;
            }
        }

        mediaFile = new File(mediaStorageDir.getPath() + File.separator

                + "IMG_" + System.currentTimeMillis() + ".jpg");//timeStamp
        try {
            //mediaFile.getParentFile().mkdirs();
            mediaFile.createNewFile();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return mediaFile;
    }
    public static boolean isDeviceSupportCamera(Context context) {
        if (context.getPackageManager().hasSystemFeature(
                PackageManager.FEATURE_CAMERA)) {
            // this device has a camera
            return true;
        } else {
            // no camera on this device
            return false;
        }
    }
    public static String getMinitues(int givenSeconds){

        String time="";

        int hours=givenSeconds/3600;
        int minitues=(givenSeconds%3600)/60;
        int seconds=givenSeconds%60;

        if(hours<10){
            time=time+"0"+hours;
        }else{
            time=time+""+hours;
        }

        if(minitues<10){
            time=time+":0"+minitues;
        }else{
            time=time+":"+minitues;
        }


        if(seconds<10){
            time=time+":0"+seconds;
        }else{
            time=time+":"+seconds;
        }

        return time;
    }

    /*public static AlertDialog alertDialog(Activity activity, String message) {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(activity);
        View dialogView = activity.getLayoutInflater().inflate(R.layout.alert_progress, null);
        dialogBuilder.setView(dialogView);
        TextView textView=dialogView.findViewById(R.id.progress_text);
        textView.setText(message);
        final AlertDialog alertDialog = dialogBuilder.create();
        alertDialog.setCancelable(false);
        alertDialog.show();

        return alertDialog;

    }
*/
    public static String getCurrentDateTime() {
        Calendar c1 = Calendar.getInstance();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df1.format(c1.getTime());
    }

    public static String getCurrentDate() {
        Calendar c1 = Calendar.getInstance();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        return df1.format(c1.getTime());
    }

    public static Bitmap processImage(Bitmap bitmap){



        /*if(bitmap.getHeight()>bitmap.getWidth()) {
            float x = (float) bitmap.getHeight() / (float) bitmap.getWidth();
            float s43 = (float) 4 / 3;
            if (x == s43) {
                bitmap = Bitmap.createScaledBitmap(bitmap, 1392, 1024, true);
            } else {
                bitmap = Bitmap.createScaledBitmap(bitmap, 936, 1664, true);
            }
        }else{
            bitmap = Bitmap.createScaledBitmap(bitmap, 1664, 936, true);
        }*/


        ByteArrayOutputStream stream = new ByteArrayOutputStream();

        if(bitmap.getHeight()>bitmap.getWidth()) {
            float x = (float) bitmap.getHeight() / (float) bitmap.getWidth();
            float s43 = (float) 4 / 3;
            if (x == s43) {
                bitmap = Bitmap.createScaledBitmap(bitmap, 720, 960, true);
            } else {
                bitmap = Bitmap.createScaledBitmap(bitmap, 720, 1280, true);
            }
        }else{
            bitmap = Bitmap.createScaledBitmap(bitmap, 1280, 720, true);
        }


        bitmap.compress(Bitmap.CompressFormat.JPEG, 95, stream);

       byte[] byteArray = stream.toByteArray();

         /*   if(byteArray.length>500000) { //200KB
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, stream);
        }
        bitmap = Bitmap.createScaledBitmap(bitmap, bitmap.getWidth()/2, bitmap.getHeight()/2, true);
        byteArray = stream.toByteArray();

        if(byteArray.length>500000) { //200KB
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, stream);
        }

        byteArray = stream.toByteArray();
        if(byteArray.length>500000) { //200KB
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, stream);
        }*/


       /* if(byteArray.length>160000) { //200KB

            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, stream);
        }*/

        Log.e("IamgeSize",byteArray.length+" b");
        return bitmap;

    }

    public static String bitmap2string(Bitmap bm) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, 100, stream);
        byte[] byteArray = stream.toByteArray();
        return Base64.encodeToString(byteArray, Base64.DEFAULT);
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();

        return networkInfo != null && networkInfo.isConnected();
    }
    public static void refreshGallery(Context context, String filePath) {
        // ScanFile so it will be appeared on Gallery
        MediaScannerConnection.scanFile(context,
                new String[]{filePath}, null,
                new MediaScannerConnection.OnScanCompletedListener(){
                    public void onScanCompleted(String path, Uri uri) {
                    }
                });
    }
}
