package com.b2lmobitech.spottest;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import com.b2lmobitech.spottest.adapter.ItemSelectedListener;
import com.b2lmobitech.spottest.adapter.ResultSectionAdapter;
import com.b2lmobitech.spottest.sql.DataBase;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MockResultActivity extends AppCompatActivity {

    RecyclerView recyclerView;
    String assignId;
    JSONArray sectionsArray;
    DataBase dataBase;
    TextView correctAnswers,questions,remarks;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_mockresult);

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Result");
        assignId=getIntent().getStringExtra("assignId");
        dataBase=new DataBase(this);

        getWidgets();

        try {
            sectionsArray =new JSONArray(getIntent().getStringExtra("json"));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        int totalquestions=0,answers=0;

        for(int i=0; i<sectionsArray.length(); i++){
            try {
                int j=dataBase.getCorrectAnswersCount(assignId,sectionsArray.getJSONObject(i).getString("section_id")).length();
                sectionsArray.getJSONObject(i).put("correct",j);
                answers=answers+j;


                int k=dataBase.getQuestions(sectionsArray.getJSONObject(i).getString("section_id"),assignId).size();
                sectionsArray.getJSONObject(i).put("counts",k);
                totalquestions=totalquestions+k;

            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        Log.d("sections",getIntent().getStringExtra("json"));

        setSections();
        correctAnswers.setText(answers+"");
        questions.setText(totalquestions+"");
        remarks.setText(String.format("%d/%d", dataBase.getMarks(assignId), dataBase.getTotalMarks(assignId)));

        findViewById(R.id.markLayout).setVisibility(View.VISIBLE);

    }

    private void getWidgets(){
        recyclerView=findViewById(R.id.recyclerView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this,DividerItemDecoration.VERTICAL));
        correctAnswers=findViewById(R.id.correctAnswers);
        questions=findViewById(R.id.questions);
        remarks=findViewById(R.id.remarks);
    }

    private void setSections()  {
        ResultSectionAdapter sectionAdapter=new ResultSectionAdapter(sectionsArray, new ItemSelectedListener() {
            @Override
            public void selected(int position) {
                try {
                    JSONObject object=sectionsArray.getJSONObject(position);
                    Intent intent=new Intent(getApplicationContext(),MockResultActivity2.class);
                    intent.putExtra("section",object.getString("section_id"));
                    intent.putExtra("assignId",assignId);
                    intent.putExtra("name",object.getString("section_name"));
                    startActivity(intent);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        recyclerView.setAdapter(sectionAdapter);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if(item.getItemId()==android.R.id.home){
            onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

}
