package com.b2lmobitech.spottest;

import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.spottest.adapter.ItemSelectedListener;
import com.b2lmobitech.spottest.adapter.ResultSectionAdapter;
import com.b2lmobitech.spottest.network.MyRequestQueue;
import com.b2lmobitech.spottest.network.URL;
import com.b2lmobitech.spottest.utils.DateUtils;
import com.b2lmobitech.spottest.utils.Preference;
import com.b2lmobitech.spottest.utils.Utility;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class ResultActivity extends AppCompatActivity {

    RecyclerView recyclerView;
    String assignId;
    TextView correctAnswers,questions,remarks,resultDatetime;
    LinearLayout resultLayout,markLayout;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_result);

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Result");
        assignId=getIntent().getStringExtra("assignid");
//--swathi--//
        SharedPreferences prefs = getSharedPreferences("X", MODE_PRIVATE);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("lastActivity", ResultActivity.class.getName());
        editor.apply();
//        Toast.makeText(getApplicationContext(), "2="+prefs.getString("lastActivity", SplashActivity.class.getName()),Toast.LENGTH_SHORT).show();
        //--swathi--//
        getWidgets();
        getSections();
    }

    private void getWidgets(){
        recyclerView=findViewById(R.id.recyclerView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this,DividerItemDecoration.VERTICAL));
        correctAnswers=findViewById(R.id.correctAnswers);
        resultLayout=findViewById(R.id.resultLayout);
        markLayout=findViewById(R.id.markLayout);
        questions=findViewById(R.id.questions);
        remarks=findViewById(R.id.remarks);
        resultDatetime=findViewById(R.id.resultDatetime);
    }

    private void getSections() {

        markLayout.setVisibility(View.GONE);
        Map<String, String> params = new HashMap<>();
        params.put("email", Preference.getInstance(this).getStudentId());
        params.put("assignId", assignId);
        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.addToQueue(URL.GET_RESULT_SECTIONS, params, new MyRequestQueue.MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {

                try {
                    setSections(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setSections(final JSONObject jsonObject) throws JSONException {

        findViewById(R.id.markLayout).setVisibility(View.VISIBLE);

        JSONObject marksObject=jsonObject.getJSONObject("marks");

        correctAnswers.setText(marksObject.getString("correct"));
        questions.setText(marksObject.getString("questions"));
        remarks.setText(String.format("%s/%s", marksObject.getString("marks"), marksObject.getString("total_marks")));

        markLayout.setVisibility(View.VISIBLE);

        final JSONArray sectionsArray=jsonObject.getJSONArray("sections");

        if(jsonObject.getBoolean("result")){
            resultLayout.setVisibility(View.GONE);
        }else{
            try {
                resultDatetime.setText(DateUtils.getNormalDatetime(jsonObject.getString("resultTime")));
                resultLayout.setVisibility(View.VISIBLE);
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }

        ResultSectionAdapter sectionAdapter=new ResultSectionAdapter(sectionsArray,jsonObject.getBoolean("result"));

        sectionAdapter.setItemSelectedListener(new ItemSelectedListener() {
            @Override
            public void selected(int position) {
                try {
                    JSONObject object=sectionsArray.getJSONObject(position);
                    Intent intent=new Intent(getApplicationContext(),ResultActivity2.class);
                    intent.putExtra("section",object.getString("section_id"));
                    intent.putExtra("name",object.getString("section_name"));
                    intent.putExtra("assignId",assignId);
                    startActivity(intent);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        recyclerView.setAdapter(sectionAdapter);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if(item.getItemId()==android.R.id.home){
            onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

}
