package com.b2lmobitech.spottest;

import android.graphics.Color;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.spottest.network.MyRequestQueue;
import com.b2lmobitech.spottest.network.URL;
import com.b2lmobitech.spottest.utils.Preference;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class ResultActivity2 extends AppCompatActivity {

    String section,assignId;
    LinearLayout mainLayout;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_result2);
        section=getIntent().getStringExtra("section");
        assignId=getIntent().getStringExtra("assignId");

        mainLayout=findViewById(R.id.mainLayout);

        getSupportActionBar().setTitle(getIntent().getStringExtra("name"));
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        getAnswers();

    }

    private void getAnswers() {

        Map<String, String> params = new HashMap<>();
        params.put("email", Preference.getInstance(this).getStudentId());
        params.put("assignId", assignId);
        params.put("section", section);

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.addToQueue(URL.GET_RESULT_ANSWERS, params, new MyRequestQueue.MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    setAnswers(jsonObject);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setAnswers(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray=jsonObject.getJSONArray("sections");
        for(int i=0; i<jsonArray.length(); i++){
            addView(jsonArray.getJSONObject(i),i+1);
        }
    }

    private void addView(final JSONObject jsonObject, int i) throws JSONException {

        View view=getLayoutInflater().inflate(R.layout.model_answer,mainLayout,false);
        TextView title=view.findViewById(R.id.question);
        title.setText(i+"."+jsonObject.getString("question"));
        TextView answer=view.findViewById(R.id.answer);
        TextView corectAnswer=view.findViewById(R.id.corectAnswer);
        LinearLayout corectAnswerLayout=view.findViewById(R.id.corectAnswerLayout);

        if(jsonObject.getString("option_name").equals("null") && jsonObject.getString("question_id").equals("null")){
            answer.setText("Not Answered");
            answer.setTextColor(Color.RED);
        }
        else if(jsonObject.getString("option_name").equals("null") && !(jsonObject.getString("question_id").equals("null"))){
            answer.setText("Dont Know");
            answer.setTextColor(Color.RED);
        }
        else{
            if (jsonObject.getBoolean("correct")) {
                answer.setTextColor(getResources().getColor(R.color.correctAnswerColor));
            } else {
                answer.setTextColor(Color.RED);
            }
            answer.setText(jsonObject.getString("option_name"));
        }

        if(!jsonObject.getBoolean("correct")){
            corectAnswer.setText(jsonObject.getString("correct_option"));
        }else{
            corectAnswerLayout.setVisibility(View.GONE);
        }

        mainLayout.addView(view);
    }

    private void addDivider(){
        View view=new View(this);
        view.setBackgroundColor(Color.DKGRAY);
        view.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,1));
        mainLayout.addView(view);

    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if(item.getItemId()==android.R.id.home){
            onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }



}
