package com.b2lmobitech.spottest.adapter;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.spottest.R;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InfoAdapter extends RecyclerView.Adapter<InfoAdapter.viewHolder> {

    private JSONArray jsonArray;

    public InfoAdapter(JSONArray jsonArray) {
        this.jsonArray = jsonArray;
    }

    @NonNull
    @Override
    public viewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.list_info,parent,false);
        return new viewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull viewHolder holder, int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());
            holder.titleText.setText(jsonObject.getString("title"));
            holder.descriptionText.setText(jsonObject.getString("instruction"));
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    class viewHolder extends RecyclerView.ViewHolder{

        TextView titleText,descriptionText;

        public viewHolder(View itemView) {
            super(itemView);
            titleText=itemView.findViewById(R.id.titleText);
            descriptionText=itemView.findViewById(R.id.descriptionText);
        }
    }

}
