package com.b2lmobitech.spottest.adapter;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.spottest.R;
import com.b2lmobitech.spottest.utils.DateUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.Date;

public class TestsAdapter extends RecyclerView.Adapter<TestsAdapter.viewHolder> {

    private JSONArray jsonArray;
    private ItemSelectedListener itemSelectedListener;
    private InfoSelectedListener infoSelectedListener;
    private Context context;


    public TestsAdapter(JSONArray jsonArray, ItemSelectedListener itemSelectedListener) {
        this.jsonArray = jsonArray;
        this.itemSelectedListener = itemSelectedListener;
    }

    @NonNull
    @Override
    public viewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.list_tests_constrain,parent,false);
        context=parent.getContext();
        return new viewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull viewHolder holder, int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());
            holder.label.setText(jsonObject.getString("question_paper_name"));
            holder.infoText1.setText(String.format("Sections : %s", jsonObject.getString("counts")));


            if(!jsonObject.getString("category").equals("null")){
                holder.categoty.setVisibility(View.VISIBLE);
                holder.bullot2.setVisibility(View.VISIBLE);
                holder.categoty.setText(jsonObject.getString("category"));
            }else{
                holder.categoty.setVisibility(View.GONE);
                holder.bullot2.setVisibility(View.GONE);
            }

            switch (jsonObject.getString("completed").toLowerCase()) {
                case "null":
                   if (jsonObject.getBoolean("canStart")) {
                        holder.active.setVisibility(View.VISIBLE);
                        holder.startText.setText("Start");
                        holder.scheduledTime.setText(DateUtils.getNormalDatetime(jsonObject.getString("examschedule_DT")));
                        holder.durationText.setText(DateUtils.getNormalHour(jsonObject.getString("paper_duration")));
                        holder.timerText.setText(DateUtils.getNormalHour(jsonObject.getInt("timer")));
                        if(jsonObject.getString("url").equalsIgnoreCase("null")){
                            holder.infoIcon.setVisibility(View.GONE);
                        }else{
                            holder.infoIcon.setVisibility(View.VISIBLE);
                        }
                        holder.timerIcon.setVisibility(View.VISIBLE);
                        holder.timerText.setVisibility(View.VISIBLE);
                        holder.nextIcon.setVisibility(View.VISIBLE);
                        holder.startText.setVisibility(View.VISIBLE);

                    }else {
                        holder.active.setVisibility(View.GONE);
                        holder.startText.setText("Preview");
                        holder.scheduledTime.setText(DateUtils.getNormalDatetime(jsonObject.getString("examschedule_DT")));
                        holder.durationText.setText(DateUtils.getNormalHour(jsonObject.getString("paper_duration")));
                        holder.timerText.setText(DateUtils.getNormalHour(jsonObject.getInt("timer")));
                        holder.infoIcon.setVisibility(View.GONE);
                        holder.timerIcon.setVisibility(View.VISIBLE);
                        holder.timerText.setVisibility(View.VISIBLE);
                        holder.nextIcon.setVisibility(View.INVISIBLE);
                        holder.startText.setVisibility(View.INVISIBLE);
                    }
                    break;
                case "no":
                        holder.active.setVisibility(View.VISIBLE);
                        holder.startText.setText("Continue");
                        holder.scheduledTime.setText(DateUtils.getNormalDatetime(jsonObject.getString("examschedule_DT")));
                        holder.durationText.setText(DateUtils.getNormalHour(jsonObject.getString("paper_duration")));
                        holder.timerText.setText(DateUtils.getNormalHour(jsonObject.getInt("timer")));
                        holder.timerText.setTextColor(Color.parseColor("#ff0000"));
                        holder.timerIcon.setVisibility(View.VISIBLE);
                        holder.timerText.setVisibility(View.VISIBLE);
                        holder.nextIcon.setVisibility(View.INVISIBLE);
                        holder.startText.setVisibility(View.INVISIBLE);
                        if(jsonObject.getString("url").equalsIgnoreCase("null")){
                            holder.infoIcon.setVisibility(View.GONE);
                        }else{
                            holder.infoIcon.setVisibility(View.VISIBLE);
                        }
                    break;
            }

        } catch (JSONException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    class viewHolder extends RecyclerView.ViewHolder{

        TextView label,infoText1,infoText2,startText,scheduledTime,durationText,timerText,categoty,bullot,bullot2;


        ImageView infoIcon,timerIcon,nextIcon;
        View active;


        public viewHolder(View itemView) {
            super(itemView);
            label=itemView.findViewById(R.id.label);
            infoText1=itemView.findViewById(R.id.infoText1);
            infoText1.setVisibility(View.GONE);
            infoText2=itemView.findViewById(R.id.infoText2);
            startText=itemView.findViewById(R.id.startText);
            infoIcon=itemView.findViewById(R.id.infoIcon);
            nextIcon=itemView.findViewById(R.id.nextIcon);
            timerText=itemView.findViewById(R.id.timerText);
            timerIcon=itemView.findViewById(R.id.timerIcon);
            active=itemView.findViewById(R.id.active);
            scheduledTime=itemView.findViewById(R.id.scheduledTime);
            durationText=itemView.findViewById(R.id.durationText);
            bullot2=itemView.findViewById(R.id.bullot2);
            categoty=itemView.findViewById(R.id.categoty);

            infoIcon.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(infoSelectedListener!=null){
                        try {
                            infoSelectedListener.showInfo(jsonArray.getJSONObject(getAdapterPosition()).getString("url"));
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    itemSelectedListener.selected(getAdapterPosition());
                }
            });

            Typeface typeface = Typeface.createFromAsset(context.getAssets(), "fonts/calibrib.ttf");
            label.setTypeface(typeface);
        }
    }

    public void setInfoSelectedListener(InfoSelectedListener infoSelectedListener) {
        this.infoSelectedListener = infoSelectedListener;
    }

    public interface InfoSelectedListener{
        void showInfo(String assignId);
    }

}
