package com.b2lmobitech.spottest.service;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Vibrator;
import android.support.v4.app.NotificationCompat;

import com.b2lmobitech.spottest.BuildConfig;
import com.b2lmobitech.spottest.R;
import com.b2lmobitech.spottest.SplashActivity;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;

import java.util.Date;

public class Myfirebasemessagingservice extends FirebaseMessagingService {


    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        //Displaying data in log
        //It is optional
        //Log.d(TAG, "From: " + remoteMessage.getFrom());
        //Log.d(TAG, "Notification Message Body: " + remoteMessage.getNotification().getBody());
        //Calling method to generate notification
        try {
            if (remoteMessage.getData().size() > 0) {
                String verision = remoteMessage.getData().get("latest");

                if (!BuildConfig.VERSION_NAME.equalsIgnoreCase(verision)) ;
                {
                    showUpdateNotification();
                }
            } else if (remoteMessage.getNotification() != null) {
                sendNotification(remoteMessage.getNotification().getBody());
                Vibrator v = (Vibrator) getSystemService(this.VIBRATOR_SERVICE);
                // Vibrate for 500 milliseconds
                v.vibrate(500);

            }
        }catch (Exception e){

        }

    }

    private void sendNotification(String messageBody) {
        try {
            Intent intent = new Intent(this, SplashActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            PendingIntent pendingIntent = PendingIntent.getActivity(this, 0 /* Request code */, intent,
                    PendingIntent.FLAG_ONE_SHOT);

            Uri defaultSoundUri= RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
            Notification.Builder notificationBuilder= new Notification.Builder(this)
                    .setSmallIcon(R.drawable.logo)
                    .setContentTitle("Spottest")
                    .setContentText(messageBody)
                    .setAutoCancel(true)
                    .setSound(defaultSoundUri)
                    .setContentIntent(pendingIntent);

            NotificationManager notificationManager =
                    (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);

            if (notificationManager != null) {
                notificationManager.notify((int) new Date().getTime(), notificationBuilder.build());
            }
        }catch (Exception e){}
    }

    private void showUpdateNotification(){

        try {
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this);
            builder.setAutoCancel(true);
// (set titles, icon, ...)

            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setData(Uri.parse("market://details?id=com.b2lmobitech.spottest"));

            builder.setContentIntent(PendingIntent.getActivity(this, 0, intent, 0));
            builder.setContentTitle("New Version available");
            builder.setContentText("click to update");
            builder.setSmallIcon(R.drawable.logo);
            Notification notification = builder.build();

            NotificationManager manager = (NotificationManager) this.getSystemService(Context.NOTIFICATION_SERVICE);
            manager.notify(0, notification);
        }catch (Exception e){}


    }

}
