package com.b2lmobitech.spottest.utils;

import android.content.Context;
import android.content.SharedPreferences;


import com.b2lmobitech.spottest.BuildConfig;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by home on 3/24/2018.
 */

public class Preference {
    private static Preference mInstance;
    private static SharedPreferences sharedPreferences;

    private Preference(Context context){
        // Get the request queue
        sharedPreferences=context.getSharedPreferences(BuildConfig.APPLICATION_ID,Context.MODE_PRIVATE);
    }

    public static synchronized Preference getInstance(Context context){
        // If Instance is null then initialize new Instance
        if(mInstance == null){
            mInstance = new Preference(context);
        }
        // Return MySingleton new Instance
        return mInstance;
    }

    public String getString(String str){
        return  sharedPreferences.getString(str,"");
    }

    public String getStudentId(){
        return  getString("student_id");
    }

    public String getUserId(){
        return  getString("userid");
    }

    public String getAPI(){
        return  getString("api");
    }

    public String getName(){
        return  getString("name");
    }

    public String getversionname(){
        return  getString("current_versionname");
    }

    public String getupdatedtime(){
        return  getString("updated_time");
    }

    public String getreg_no(){
        return  getString("reg_no");
    }

    public void setExamStatus(boolean isOngoing){
        sharedPreferences.edit().putBoolean("isOngoing",isOngoing).apply();
    }

    public boolean getExamStatus(){
        return  sharedPreferences.getBoolean("isOngoing",false);
    }

    public void putString(String key,String pair){
            sharedPreferences.edit().putString(key,pair).apply();
    }

    public void putString(HashMap<String,String> hashMap){
        SharedPreferences.Editor sh= sharedPreferences.edit();
        for(Map.Entry<String, String> e : hashMap.entrySet()) {
            sh.putString(e.getKey(),e.getValue());
        }
        sh.apply();
    }

}
